% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_data_processing.R
\name{processingRawData}
\alias{processingRawData}
\title{Data processing}
\usage{
processingRawData(file_name, source_dir, results_dir, mismatch = 0,
  label = "", bc_pattern, quality_filtering = FALSE, min_score = 30,
  min_reads = 2, unix = FALSE, save_it = TRUE, cpus = 1)
}
\arguments{
\item{file_name}{a character string which will serve as file name.}

\item{source_dir}{a character string which contains the path to the source files.}

\item{results_dir}{a character string which contains the path to the results directory.}

\item{mismatch}{an positive integer value, default is 0, if greater values are provided they indicate the number of allowed mismtaches when identifying the barcode constructes.}

\item{label}{a character string which serves as a label for every kind of created output file.}

\item{bc_pattern}{a character string describing the barcode design, variable positions have to be marked with the letter 'N'.}

\item{quality_filtering}{a logical value. If TRUE a quality filtering will be applied before extracting the barcode sequences}

\item{min_score}{a positive integer value, only relevant if quality_filtering is TRUE, all fastq sequence with an average score smaller
then min_score will be excluded}

\item{min_reads}{positive integer value, all extracted barcode sequences with a read count smaller than min_reads will be excluded from the results}

\item{unix}{under construction}

\item{save_it}{a logical value. If TRUE, the raw data will be saved as a csv-file.}

\item{cpus}{a positive integer identifying the number of usable CPUs.}
}
\value{
a BCdat object which includes reads, seqs, directories, masks.
}
\description{
Reads the corresponding fast(q) file(s), extracts the defined barcode constructs and counts them. Optionally,
a Phred-Score based quality filtering will be conducted and the results will be saved within a csv file.
}
\examples{

\dontrun{

bc_pattern <- "ACTNNCGANNCTTNNCGANNCTTNNGGANNCTANNACTNNCGANNCTTNNCGANNCTTNNGGANNCTANNACTNNCGANN"

source_dir <- system.file("extdata", package = "genBaRcode")

processingRawData(file_name = "test_data.fastq", source_dir, results_dir = getwd(), mismatch = 0,
label = "test", bc_pattern, quality_filtering = FALSE, min_score = 30,
min_reads = 2, unix = FALSE, save_it = TRUE)

}
}
