/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.ParameterizedODE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterizedWrapper
implements ParameterizedODE {
    private final FirstOrderDifferentialEquations fode;

    public ParameterizedWrapper(FirstOrderDifferentialEquations ode) {
        this.fode = ode;
    }

    public int getDimension() {
        return this.fode.getDimension();
    }

    public void computeDerivatives(double t, double[] y, double[] yDot) {
        this.fode.computeDerivatives(t, y, yDot);
    }

    @Override
    public Collection<String> getParametersNames() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isSupported(String name) {
        return false;
    }

    @Override
    public double getParameter(String name) throws MathIllegalArgumentException {
        if (!this.isSupported(name)) {
            throw new MathIllegalArgumentException(LocalizedFormats.UNKNOWN_PARAMETER, name);
        }
        return Double.NaN;
    }

    @Override
    public void setParameter(String name, double value) {
    }
}

