/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.AbstractLogDensity;
import gov.lanl.yadas.Tools;

public class Hypergeometric
extends AbstractLogDensity {
    double y;
    double n;
    double N;
    double C;

    public double compute(double[][] args, int i) {
        this.y = args[0][i];
        this.n = args[1][i];
        this.N = args[2][i];
        this.C = args[3][i];
        return Hypergeometric.logchoose(this.n, this.y, -1) + Hypergeometric.logchoose(this.N - this.n, this.C - this.y, -1) - Hypergeometric.logchoose(this.N, this.C, 1);
    }

    public static double logchoose(double n, double x, int direction) {
        if (x > n || x < 0.0 || n < 0.0) {
            if (direction < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0 || x == n) {
            return 0.0;
        }
        return Tools.loggamma(n + 1.0) - Tools.loggamma(x + 1.0) - Tools.loggamma(n - x + 1.0);
    }
}

