/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.lang.StringUtils;
import org.drugis.common.CollectionHelper;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.TreatmentComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InconsistencyParameter
implements NetworkParameter,
Comparable<InconsistencyParameter> {
    private final List<Treatment> d_cycle;
    private static final Transformer<Treatment, String> s_idTransformer = new Transformer<Treatment, String>(){

        @Override
        public String transform(Treatment input) {
            return input.getId();
        }
    };

    public InconsistencyParameter(List<Treatment> cycle) {
        this.d_cycle = cycle;
    }

    @Override
    public String getName() {
        return "w." + StringUtils.join(CollectionHelper.transform(this.d_cycle.subList(0, this.d_cycle.size() - 1), s_idTransformer), ".");
    }

    public List<Treatment> getCycle() {
        return Collections.unmodifiableList(this.d_cycle);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InconsistencyParameter) {
            InconsistencyParameter other = (InconsistencyParameter)obj;
            return ((Object)this.d_cycle).equals(other.d_cycle);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.d_cycle).hashCode();
    }

    @Override
    public int compareTo(InconsistencyParameter other) {
        return this.compare(this.d_cycle, other.d_cycle, TreatmentComparator.INSTANCE);
    }

    private <E> int compare(List<? extends E> l1, List<? extends E> l2, Comparator<? super E> cmp) {
        int n = Math.min(l1.size(), l2.size());
        for (int i = 0; i < n; ++i) {
            int c = cmp.compare(l1.get(i), l2.get(i));
            if (c == 0) continue;
            return c;
        }
        return l1.size() - l2.size();
    }
}

