/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.summary.MultivariateNormalSummary;

public class TransformedMultivariateNormalSummary
extends AbstractObservable
implements MultivariateNormalSummary {
    private final MultivariateNormalSummary d_nested;
    private final RealMatrix d_transform;
    private boolean d_isDefined;
    private RealMatrix d_means;
    private RealMatrix d_covarianceMatrix;

    public TransformedMultivariateNormalSummary(MultivariateNormalSummary nested, double[][] matrix) {
        this.d_nested = nested;
        this.d_transform = new Array2DRowRealMatrix(matrix, true);
        this.d_nested.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransformedMultivariateNormalSummary.this.transform();
            }
        });
        this.transform();
    }

    @Override
    public boolean getDefined() {
        return this.d_isDefined;
    }

    @Override
    public double[] getMeanVector() {
        return this.d_means.getColumn(0);
    }

    @Override
    public double[][] getCovarianceMatrix() {
        return this.d_covarianceMatrix.getData();
    }

    protected void transform() {
        if (!this.d_nested.getDefined()) {
            this.d_isDefined = false;
            return;
        }
        this.d_means = this.d_transform.multiply(new Array2DRowRealMatrix(this.d_nested.getMeanVector()));
        this.d_covarianceMatrix = this.d_transform.multiply(new Array2DRowRealMatrix(this.d_nested.getCovarianceMatrix(), true).multiply(this.d_transform.transpose()));
        this.d_isDefined = true;
        this.firePropertyChange("defined", null, this.d_isDefined);
        this.firePropertyChange("meanVector", null, this.getMeanVector());
        this.firePropertyChange("covarianceMatrix", null, this.getCovarianceMatrix());
    }
}

