/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MultipleParameterUpdate;
import gov.lanl.yadas.TunableMCMCUpdate;
import gov.lanl.yadas.TunablePerturber;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;

public class TunableMultipleParameterUpdate
extends MultipleParameterUpdate
implements TunableMCMCUpdate {
    boolean firsttuneoutput = true;
    PrintWriter tune_out;
    public NumberFormat nft;
    public String name;
    private static int instanceCounter = 0;

    public TunableMultipleParameterUpdate(MCMCParameter[] params, TunablePerturber perturber, String name) {
        super(params, perturber);
        this.name = name;
        this.nft = NumberFormat.getNumberInstance();
        this.nft.setMaximumFractionDigits(3);
        this.nft.setGroupingUsed(false);
    }

    public double[] getStepSizes() {
        return ((TunablePerturber)this.perturber).getStepSizes();
    }

    public void setStepSize(double s, int i) {
        ((TunablePerturber)this.perturber).setStepSize(s, i);
    }

    public void setStepSizes(double[] s) {
        ((TunablePerturber)this.perturber).setStepSizes(s);
    }

    public String toStringTune() {
        String out = "";
        double[] temp = this.getStepSizes();
        for (int i = 0; i < temp.length - 1; ++i) {
            out = out + this.nft.format(temp[i]) + "|";
        }
        out = out + this.nft.format(temp[temp.length - 1]);
        return out;
    }

    public void tuneoutput() {
        if (this.firsttuneoutput) {
            this.firsttuneoutput = false;
            try {
                this.tune_out = new PrintWriter(new FileWriter(this.name + ".tun"));
            }
            catch (IOException e) {
                System.out.print("Error: " + e);
                System.exit(1);
            }
        }
        this.tune_out.println(this.toStringTune());
    }

    public void finish() {
        if (!this.firsttuneoutput) {
            this.tune_out.close();
        }
    }
}

