/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.DoubleIntProcedure;
import cern.colt.function.DoubleProcedure;
import cern.colt.function.IntComparator;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractDoubleIntMap
extends AbstractMap {
    protected AbstractDoubleIntMap() {
    }

    public boolean containsKey(final double d) {
        return !this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d2) {
                return d != d2;
            }
        });
    }

    public boolean containsValue(final int n) {
        return !this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double d, int n2) {
                return n != n2;
            }
        });
    }

    public AbstractDoubleIntMap copy() {
        return (AbstractDoubleIntMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractDoubleIntMap)) {
            return false;
        }
        final AbstractDoubleIntMap abstractDoubleIntMap = (AbstractDoubleIntMap)object;
        if (abstractDoubleIntMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double d, int n) {
                return abstractDoubleIntMap.containsKey(d) && abstractDoubleIntMap.get(d) == n;
            }
        }) && abstractDoubleIntMap.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double d, int n) {
                return AbstractDoubleIntMap.this.containsKey(d) && AbstractDoubleIntMap.this.get(d) == n;
            }
        });
    }

    public abstract boolean forEachKey(DoubleProcedure var1);

    public boolean forEachPair(final DoubleIntProcedure doubleIntProcedure) {
        return this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d) {
                return doubleIntProcedure.apply(d, AbstractDoubleIntMap.this.get(d));
            }
        });
    }

    public abstract int get(double var1);

    public double keyOf(final int n) {
        final double[] dArray = new double[1];
        boolean bl = this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double d, int n2) {
                boolean bl;
                boolean bl2 = bl = n == n2;
                if (bl) {
                    dArray[0] = d;
                }
                return !bl;
            }
        });
        if (bl) {
            return Double.NaN;
        }
        return dArray[0];
    }

    public DoubleArrayList keys() {
        DoubleArrayList doubleArrayList = new DoubleArrayList(this.size());
        this.keys(doubleArrayList);
        return doubleArrayList;
    }

    public void keys(final DoubleArrayList doubleArrayList) {
        doubleArrayList.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d) {
                doubleArrayList.add(d);
                return true;
            }
        });
    }

    public void keysSortedByValue(DoubleArrayList doubleArrayList) {
        this.pairsSortedByValue(doubleArrayList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final DoubleIntProcedure doubleIntProcedure, final DoubleArrayList doubleArrayList, final IntArrayList intArrayList) {
        doubleArrayList.clear();
        intArrayList.clear();
        this.forEachPair(new DoubleIntProcedure(){

            public boolean apply(double d, int n) {
                if (doubleIntProcedure.apply(d, n)) {
                    doubleArrayList.add(d);
                    intArrayList.add(n);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(DoubleArrayList doubleArrayList, IntArrayList intArrayList) {
        this.keys(doubleArrayList);
        doubleArrayList.sort();
        intArrayList.setSize(doubleArrayList.size());
        int n = doubleArrayList.size();
        while (--n >= 0) {
            intArrayList.setQuick(n, this.get(doubleArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(DoubleArrayList doubleArrayList, IntArrayList intArrayList) {
        this.keys(doubleArrayList);
        this.values(intArrayList);
        final double[] dArray = doubleArrayList.elements();
        final int[] nArray = intArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return nArray[n] < nArray[n2] ? -1 : (nArray[n] > nArray[n2] ? 1 : (dArray[n] < dArray[n2] ? -1 : (dArray[n] == dArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, doubleArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(double var1, int var3);

    public abstract boolean removeKey(double var1);

    public String toString() {
        DoubleArrayList doubleArrayList = this.keys();
        doubleArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = doubleArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            double d = doubleArrayList.get(i);
            stringBuffer.append(String.valueOf(d));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(d)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.keysSortedByValue(doubleArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = doubleArrayList.size() - 1;
        for (int i = 0; i <= n; ++i) {
            double d = doubleArrayList.get(i);
            stringBuffer.append(String.valueOf(d));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(d)));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IntArrayList values() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.values(intArrayList);
        return intArrayList;
    }

    public void values(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double d) {
                intArrayList.add(AbstractDoubleIntMap.this.get(d));
                return true;
            }
        });
    }
}

