% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_audio.R
\name{gemini_audio}
\alias{gemini_audio}
\title{Analyze audio using Gemini}
\usage{
gemini_audio(
  audio = NULL,
  prompt = "Describe this audio",
  model = "1.5-flash",
  temperature = 0.5,
  maxOutputTokens = 1024
)
}
\arguments{
\item{audio}{Path to the audio file (default: uses a sample file).  Must be an MP3.}

\item{prompt}{A string describing what to do with the audio.}

\item{model}{The Gemini model to use ("1.5-flash" or "1.5-pro", "2.0-flash-exp"). Defaults to "1.5-flash".}

\item{temperature}{Controls the randomness of the generated text (0-2).  Defaults to 0.5.}

\item{maxOutputTokens}{The maximum number of tokens in the generated text. Defaults to 1024.}
}
\value{
A character vector containing the Gemini API's response.
}
\description{
This function sends audio to the Gemini API and returns a text description.
}
\examples{
\dontrun{
library(gemini.R)
setAPI("YOUR_API_KEY")
gemini_image(audio = system.file("docs/reference/helloworld.mp3", package = "gemini.R"))
}

}
