% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geese.R
\name{geese.control}
\alias{geese.control}
\title{Auxiliary for Controlling GEE Fitting}
\usage{
geese.control(
  epsilon = 1e-04,
  maxit = 25,
  trace = FALSE,
  scale.fix = FALSE,
  jack = FALSE,
  j1s = FALSE,
  fij = FALSE
)
}
\arguments{
\item{epsilon}{positive convergence tolerance epsilon; the
iterations converge when the absolute value of the difference
in parameter estimate is below \code{epsilon}.}

\item{maxit}{integer giving the maximal number of Fisher Scoring
iteration.}

\item{trace}{logical indicating if output should be produced for
each iteration.}

\item{scale.fix}{logical indicating if the scale should be fixed.}

\item{jack}{logical indicating if approximate jackknife variance
estimate should be computed.}

\item{j1s}{logical indicating if 1-step jackknife variance estimate
should be computed.}

\item{fij}{logical indicating if fully iterated jackknife variance
estimate should be computed.}
}
\value{
A list with the arguments as components.
}
\description{
Auxiliary function as user interface for `gee' fitting. Only used when
calling `geese' or `geese.fit'.
}
\details{
When `trace' is true, output for each iteration is printed to the screen by
the c++ code. Hence, `options(digits = *)' does not control the precision.
}
\seealso{
`geese.fit', the fitting procedure used by `geese'.
}
\author{
Jun Yan \email{jyan.stat@gmail.com}
}
\keyword{models}
\keyword{optimize}
