% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_history_snapshot.R
\name{coin_history_snapshot}
\alias{coin_history_snapshot}
\title{History snapshot for a coin}
\usage{
coin_history_snapshot(coin_id, date, vs_currencies = "usd", max_attempts = 3)
}
\arguments{
\item{coin_id}{(character): ID of the coin of interest or a vector with \emph{several} IDs.
The maximum number of coins that can be queried simultaneously is 30.
An up-to-date list of supported coins and their IDs can be retrieved
with the \code{supported_coins()} function.}

\item{date}{(Date): date of interest. If no data exist for the requested
date, nothing (\code{NULL}) will be returned.}

\item{vs_currencies}{(character): a vector with
names of the reference currencies to express the price in, e.g.
\code{c("usd", "eur", "btc")}. An up-to-date list of supported
\code{vs_currencies} (both fiat and cryptocurrencies) can be obtained with
the \code{\link[=supported_currencies]{supported_currencies()}} function. If \code{vs_currencies}
contains at least one unsupported currency, the call will fail with the
respective error message.}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{coin_id} (character): same as the argument \code{coin_id};
\item \code{symbol} (character): symbol of the coin;
\item \code{name} (character): common name of the coin;
\item \code{date} (Date): same as the argument \code{date};
\item \code{vs_currency} (character): reference currency, in which the \code{price}
is expressed (ordered alphabetically);
\item \code{price} (double): price of the coin;
\item \code{market_cap} (double): market capitalisation of the coin;
\item \code{total_volume} (double): total trading volume recorded on that \code{date}.
}
}
\description{
Coin-specific market data for a given historical date
}
\details{
This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- coin_history_snapshot(
  coin_id = "cardano",
  date = as.Date("2021-05-01"),
  vs_currencies = c("usd", "eth")
)
print(r)
}
}
