% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commuteDistance.R
\name{commuteDistance}
\alias{commuteDistance}
\alias{commuteDistance,TransitionLayer,Coords-method}
\title{Commute-time distance}
\usage{
commuteDistance(x, coords)
}
\arguments{
\item{x}{object of class \code{TransitionLayer}}

\item{coords}{point locations coordinates
(of SpatialPoints, matrix or numeric class)}
}
\value{
distance matrix (S3 class dist or matrix)
}
\description{
Calculates the resistance distance between points.
}
\details{
This function calculates the expected random-walk commute
 time between nodes in a graph. It is defined as the effective
 distance (resistance distance) between the selected nodes multiplied
 by the volume of the graph, which is the sum of the conductance
 weights of all the edges in the graph (Chandra et al. 1997). The
 result represents the average number of steps that is needed to
 commute between the nodes during a random walk.

The function implements the algorithm given by Fouss et al. (2007).

Before calculating commute-time distances from a \code{TransitionLayer}
 object, see if you need to apply the function
 \code{\link{geoCorrection}}
}
\examples{
library("raster")
# Create a new raster and set all its values to unity.
r <- raster(nrows=18, ncols=36)
r <- setValues(r,rep(1,ncell(raster)))

#Create a Transition object from the raster
tr <- transition(r, function(x) 1/mean(x),4)

# Create two sets of coordinates
library("sp")
sP1 <- SpatialPoints(cbind(c(65,5,-65),c(55,35,-35)))
sP2 <- SpatialPoints(cbind(c(50,15,-40),c(80,20,-5)))

#Calculate the resistance distance between the points
commuteDistance(tr, sP1)

}
\references{
Chandra, A.K., Raghavan, P., Ruzzo, W.L., Smolensy, R. & Tiwari, P. 1996.
 The electrical resistance of a graph captures its commute and cover times.
 Computational Complexity, 6(4), 312-340.

Fouss, F., Pirotte, A., Renders, J.-M. & Saerens, M. 2007.
 Random-walk computation of similarities between nodes of a
 graph with application to collaborative recommendation. IEEE
 Transactions on Knowledge and Data Engineering, 19(3), 355-369.

McRae, B.H. 2006. Isolation by resistance. Evolution 60(8), 1551-1561.
\url{https://circuitscape.org/}
}
\seealso{
\code{\link{geoCorrection}}
}
\author{
Jacob van Etten
}
\keyword{spatial}
