% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_rename}
\alias{vsi_rename}
\title{Rename a file}
\usage{
vsi_rename(oldpath, newpath)
}
\arguments{
\item{oldpath}{Character string. The name of the file to be renamed.}

\item{newpath}{Character string. The name the file should be given.}
}
\value{
Invisibly, \code{0} on success or \code{-1} on an error.
}
\description{
\code{vsi_rename()} renames a file object in the file system. The GDAL
documentation states it should be possible to rename a file onto a new
filesystem, but it is safest if this function is only used to rename files
that remain in the same directory.
This function goes through the GDAL \code{VSIFileHandler} virtualization and may
work on unusual filesystems such as in memory.
It is a wrapper for \code{VSIRename()} in the GDAL Common Portability Library.
Analog of the POSIX \code{rename()} function.
}
\examples{
# for illustration only
# this would normally be used with GDAL virtual file systems
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
tmp_file <- tempfile(fileext = ".tif")
file.copy(elev_file, tmp_file)
new_file <- file.path(dirname(tmp_file), "storml_elev_copy.tif")
result <- vsi_rename(tmp_file, new_file)
print(result)
}
\seealso{
\code{\link[=renameDataset]{renameDataset()}}, \code{\link[=vsi_copy_file]{vsi_copy_file()}}
}
