% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalmdimtranslate.R
\name{gdalmdimtranslate}
\alias{gdalmdimtranslate}
\title{Interface to GDAL's gdalmdimtranslate utility}
\usage{
gdalmdimtranslate(
  src_filename,
  dst_filename,
  ...,
  co,
  IF,
  of,
  array,
  group,
  subset,
  scaleaxes,
  oo,
  config_options = character(0),
  dryrun = FALSE
)
}
\arguments{
\item{src_filename}{Character. Path to a GDAL-supported readable
datasource.}

\item{dst_filename}{Character. Path to a GDAL-supported output
file.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{co, IF, of, array, group, subset, scaleaxes, oo}{See the GDAL
project's
\href{https://gdal.org/programs/gdalmdimtranslate.html}{gdalmdimtranslate
documentation} for details.}

\item{config_options}{A named character vector with GDAL config
options, of the form \code{c(option1=value1, option2=value2)}. (See
\href{https://gdal.org/user/configoptions.html}{here} for a
complete list of supported config options.)}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}
}
\value{
Silently returns path to \code{dst_filename}.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{gdalmdimtranslate}. For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/gdalmdimtranslate.html}.
}
\examples{
\donttest{
## A simple dataset bundled with the sf package
FF <- system.file("nc/cropped.nc", package = "sf")
td <- tempdir()
out_tiff <- file.path(td, "out.tiff")
gdalinfo(FF)
gdalmdimtranslate(FF, out_tiff, array = "sst")
gdalinfo(out_tiff)

## A more interesting dataset bundled with the stars package
if (requireNamespace("raster", quietly = TRUE)) {
    library(raster)
    FF <- system.file("nc/reduced.nc", package = "stars")
    gdalinfo(FF)
    td <- tempdir()
    out_1_tiff <- file.path(td, "out_1.tiff")
    gdalmdimtranslate(FF, out_1_tiff, array = "sst")
    plot(raster(out_1_tiff),
         main = "Sea Surface Temperature\n(2x2 degree cells)")
    ## Translate to a tiff, coarsen by a factor of 5
    out_2_tiff <- file.path(td, "out_2.tiff")
    gdalmdimtranslate(FF, out_2_tiff, array = "sst",
                      scaleaxes = "lon(5),lat(5)")
    plot(raster(out_2_tiff),
         main = "Sea Surface Temperature\n(10x10 degree cells)")
}
}
}
\author{
Joshua O'Brien
}
