% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.rsb.R
\name{gbm.rsb}
\alias{gbm.rsb}
\title{Representativeness Surface Builder}
\usage{
gbm.rsb(samples, grids, expvarnames, gridslat, gridslon)
}
\arguments{
\item{samples}{Data frame with response and explanatory variables.}

\item{grids}{Data frame of (more/different) explanatory variables and no
response variable, to be predicted to by gbm.predict.grids.}

\item{expvarnames}{Vector of column names of explanatory variables being
tested. Can be length 1. Names must match in samples and grids.}

\item{gridslat}{Column number for latitude in 'grids'.}

\item{gridslon}{Column number for longitude in 'grids'.}
}
\value{
Gridded data table of representativeness values which is then mapped
with gbm.map and also saved as a csv
}
\description{
Loops through explanatory variables comparing their histogram in 'samples' to
their histogram in 'grids' to see how well the explanatory variable range in
samples represents the range being predicted to in grids. Assigns a
representativeness score per variable per site in grids, and takes the
average score per site if there's more than 1 expvar. Saves this to a CSV;
it's plotted by gbm.map if called in gbm.auto. This shows you which areas
have the most and least representative coverage by samples, therefore where you
can have the most/least confidence in the predictions from gbm.predict.grids.
Can be called directly, and choosing a subset of expvars allows one to see
their individual / collective representativeness.
}
\examples{
data(samples)
data(grids)
rsbdf_bin <- gbm.rsb(samples, grids, expvarnames = names(samples[c(4:8, 10)])
, gridslat = 2, gridslon = 1)

}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
