% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ggplot.garma_model}
\alias{ggplot.garma_model}
\title{The ggplot function generates a ggplot of actuals and predicted values for a "garma_model" object.}
\usage{
\method{ggplot}{garma_model}(mdl, h = 24, ...)
}
\arguments{
\item{mdl}{(garma_model) The garma_model from which to ggplot the values.}

\item{h}{(int) The number of time periods to predict ahead. Default: 24}

\item{...}{other parameters passed to ggplot.}
}
\value{
A ggplot2 "ggplot" object. Note that the standard ggplot2 "+" notation can be used to enhance the default output.
}
\description{
The ggplot function generates a ggplot of actuals and predicted values for a "garma_model" object.
}
\examples{
library(ggplot2)

data(AirPassengers)
ap  <- as.numeric(diff(AirPassengers,12))
mdl <- garma(ap,order=c(9,1,0),k=0,method='CSS',include.mean=FALSE)
ggplot(mdl)
}
