% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-garch_reg_params.R
\name{garch_params}
\alias{garch_params}
\alias{arch_order}
\alias{garch_order}
\alias{ar_order}
\alias{ma_order}
\title{Tuning Parameters for Univariate Garch Models}
\usage{
arch_order(range = c(0L, 3L), trans = NULL)

garch_order(range = c(0L, 3L), trans = NULL)

ar_order(range = c(0L, 5L), trans = NULL)

ma_order(range = c(0L, 5L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A quant param

A quant param

A quant param

A quant param
}
\description{
Tuning Parameters for Univariate Garch Models
}
\details{
The main parameters for Univariate Garch models are:
\itemize{
\item \code{arch_order}: The order corresponding to the ARCH part.
\item \code{garch_order}: The order corresponding to the GARCH part.
\item \code{ar_order}: The order of the non-seasonal auto-regressive (AR) terms.
\item \code{ma_order}: The order of the non-seasonal moving average (MA) terms.
}
}
\examples{
arch_order()

garch_order()

ar_order()

ma_order()


}
