% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{SegmentConditionFilter}
\alias{SegmentConditionFilter}
\alias{SegmentConditionFilter,ANY-method}
\title{SegmentConditionFilter.}
\usage{
SegmentConditionFilter(object, ..., negation, scope)

\S4method{SegmentConditionFilter}{ANY}(object, ..., negation, scope)
}
\arguments{
\item{object}{An expression to be used as a non-sequential segment condition.}

\item{...}{Other expressions to be ANDed to the first expression provided.}

\item{negation}{optional logical TRUE or FALSE to match segments where this condition
has not been met. Default is FALSE, i.e. inclusive filter.}

\item{scope}{optional scope, "users" or "sessions".}
}
\value{
a gaSegmentConditionFilter object.
}
\description{
Create a new gaSegmentConditionFilter object
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Create a non-sequential segment condition
filter from one or more expressions. All conditions within the filter must
hold true within a single session if applied to a gaDynSegment
scoped at session-level, or to a single hit if scoped at user-level.
}}

