% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{GammaSpectra-class}
\alias{GammaSpectra-class}
\alias{.GammaSpectra}
\title{An S4 Class to Represent a Collection of Gamma Sectra}
\description{
Represents a collection of spectra of gamma ray spectrometry measurements.
}
\details{
This class extends the base \code{\link{list}} and can only contains
\linkS4class{GammaSpectrum} objects.
}
\section{Access}{

In the code snippets below, \code{x} is a \code{GammaSpectra} object.
\describe{
\item{\code{length(x)}}{Get the number of elements in \code{x}.}
\item{\code{lengths(x)}}{Get the number of channels in each element of \code{x}.}
\item{\code{get_names(x)}, \code{set_names(x) <- value}}{Retrieves or sets
the names of \code{x} according to \code{value}.}
\item{\code{get_hash(x)}}{Get the MD5 hash of the raw data files.}
\item{\code{get_channels(x)}}{Get the number of channels in each element of \code{x}.}
\item{\code{get_counts(x)}}{Get the counts of each element of \code{x}.}
\item{\code{get_energy(x)}}{Get the energy range of each element of \code{x}.}
\item{\code{get_rates(x)}}{Get the count rates of each element of \code{x}.}
}
}

\section{Subset}{

In the code snippets below, \code{x} is a \code{GammaSpectra} object.
\describe{
\item{\code{x[i]}}{Extracts the elements selected by subscript \code{i}.
\code{i} can be \code{missing} or \code{NULL}, \code{numeric} or \code{character} vector or a
\code{factor}. Returns a new \code{GammaSpectra} object.}
\item{\code{x[i, j]}}{Like the above but allows to select a slot thru \code{j} (see
examples). \code{j} is a \code{character} vector of length one. Returns a \code{list}.}
\item{\code{x[[i]]}}{Extracts the elements selected by subscript \code{i}.
\code{i} can be a \code{numeric} or \code{character} vector of length one. Returns the
corresponding \linkS4class{GammaSpectrum} object.}
}
}

\examples{
## Import all CNF files in a given directory
spc_dir <- system.file("extdata/BDX_LaBr_1/calibration", package = "gamma")
(spc <- read(spc_dir))

## Access
get_hash(spc)
get_names(spc)
get_livetime(spc)
get_realtime(spc)

lengths(spc)
range_energy(spc)

## Subset
spc[] # All spectra
spc[NULL] # All spectra
spc[1] # The first spectrum
spc[-6] # Delete the sixth spectrum
spc[1:3] # The first three spectra
spc[c(1, 3)] # The first and third spectra
spc["BRIQUE"] # The spectrum named 'BRIQUE'
spc[c("BRIQUE", "C347")] # The spectra named 'BRIQUE' and 'C347'
spc[1:3, "energy"] # The slot 'energy' of the first three spectra
spc[[1]]
spc[["BRIQUE"]]
}
\seealso{
Other class: 
\code{\link{Baseline-class}},
\code{\link{CalibrationCurve-class}},
\code{\link{GammaSpectrum-class}},
\code{\link{PeakPosition-class}},
\code{\link{coerce}()}
}
\author{
N. Frerebeau
}
\concept{class}
