% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{get_project_type_custom_attributes}
\alias{get_project_type_custom_attributes}
\title{Retrieve Highbond Projects - Project Type Custom Attributes}
\usage{
get_project_type_custom_attributes(
  auth,
  project_type_id = NULL,
  custom_attributes_id = NULL,
  fields = NULL,
  pagesize = 50,
  waittime = 0.2
)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{project_type_id}{Required if other parameter is blank.}

\item{custom_attributes_id}{Required if the other parameter is blank. Base64
encoded parent resource id (project or framework) and user uid, encoded
from format \code{parent_resource_id:user_uid.}.}

\item{fields}{OPTIONAL. A character vector each field requested within the
project. NULL will default to all fields.}

\item{pagesize}{Defaults to 50. Maximum is 100.}

\item{waittime}{Time in seconds to wait between requests.}
}
\value{
A tibble of custom attributes
}
\description{
Get the custom attributes set within a project type. Note these
are different than the custom terms used to rename fields. For those, see
\link[galvanizer]{get_project_types}
}
