% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{create_results_collections}
\alias{create_results_collections}
\alias{update_results_collections}
\alias{delete_results_collections}
\title{Create, Update or Delete Results - Collections}
\usage{
create_results_collections(auth, name, ...)

update_results_collections(auth, collection_id, ...)

delete_results_collections(auth, collection_id)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{name}{The name of the Results object to create}

\item{...}{List(s) to add additional data}

\item{collection_id}{The ID number of the collection}
}
\value{
If creating or updating, a data frame with the new details.
When deleting, JSON response indicating success or failure.
}
\description{
Create, Update or Delete Results - Collections
}
\details{
Each endpoint has a list of required elements, as listed in the
parameters.

For optional data, such as attributes, you may pass additional lists. The
top level name of this optional list should match the name of the json
level to be added, with key-value pairs within the list. Ultimately, this
list object will be added as a child json level, under the 'data' top level
json.

For example: \code{attributes} is a json is nested under data, and therefore
should be created as the name of the object. Then additional information
can be added to it as a key-value pair to the list.
}
\section{Functions}{
\itemize{
\item \code{update_results_collections}: Update a collection

\item \code{delete_results_collections}: Delete a collection
}}

\examples{
\dontrun{
# Create and delete a Collection
auth <- setup_highbond(Sys.getenv('highbond_openapi'), 
  Sys.getenv('highbond_org'), 
  Sys.getenv('highbond_datacenter'))
  
name <- 'galvanizer Test Collection'
response <- create_results_collections(auth, name)
collection_id <- response$id[[1]]
response <- delete_results_collections(auth, collection_id)

# Create a Collection with attributes
myattr <- list(description = 'My first description')
response <- create_results_collections(auth, name, attributes = myattr)
collection_id <- response$id[[1]]

# Update a Collection with attributes
myattr <- list(name = 'galvanizer Super Test Collection', description = 'My second description')
response <- update_results_collections(auth, collection_id, attributes = myattr)

# Delete a Collection
response <- delete_results_collections(auth, collection_id)
}
}
