% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_taxonomy.R
\name{search_taxonomy}
\alias{search_taxonomy}
\title{Search taxonomic trees}
\usage{
search_taxonomy(query, down_to = NULL)
}
\arguments{
\item{query}{\code{string}: A vector containing one or more search terms,
given as strings. Search terms can be scientific or common names, or
taxonomic identifiers. If greater control is required to disambiguate search
terms, taxonomic levels can be provided explicitly via a named \code{list}
for a single name. See vignette(taxonomic_information for using search_taxonomy
for multiple clades)
Note that searches are not case-sensitive.}

\item{down_to}{\code{string}: A taxonomic rank to search down to. See
\code{\link{find_ranks}} for valid inputs.}
}
\value{
a \code{data.frame} containing one row per terminal node, and one 
column for every available intermediate taxonomic level.
}
\description{
The ALA has its' own internal taxonomy that is derived from authoritative
sources. \code{search_taxonomy} provides a means to query and visualise 
that taxonomy, by showing which lower clades are contained within a specified taxon.
The inverse query - i.e. listing the higher clades to which a taxon belongs
- is provided by \code{\link{select_taxa}()}.
}
\details{
The approach used by this function is recursive, meaning that it  
becomes slow for large queries such as  
\code{search_taxonomy("Animalia", down_to = "species")}. The resulting 
\code{data.frame} can be passed to \code{\link{select_taxa}} to extract
unique identifiers for the terminal nodes (rows), which is necessary to use later 
functions such as \code{\link{ala_counts}} or \code{\link{ala_occurrences}}.
}
\examples{
\dontrun{
search_taxonomy("Animalia", down_to = "class")
}
}
\seealso{
\code{\link{select_taxa}} to search for an individual clade; 
\code{\link{find_ranks}} for valid ranks used to specify the \code{down_to}
argument.
}
