##' Generate multiple initial vectors for the nls function in sgSEMp1().
##'
##' Currently the non-linearizable function included in sgSEMp1() is y = a + b * exp(c * x), where a, b and c are coefficients to be estimated. Thus, an initial vector contains three values. The random initial values are generated by a uniform distribution between the bounds. 
##'
##' @title Generate initial values for nls function
##' @param bounds a list of three vectors of length = 2. Each vector gives the upper and lower limits of an interval from which the initial values are randomly generated. The default values list(a1 = c(-3, 3), a2 = c(-3, 3), a3 = c(-3, 3)) sets limits of all three initial values to be (-3, 3).
##' @param k a positive integer (default = 50). The number of initial vectors to generate.
##' @export
##' @importFrom 'stats' 'runif'
##' @return A data frame. Each column corresponds to a coefficient. Each row corresponds to a random initial vector.
##'
##' @examples
##' genInit(list(a1 = c(0,2), a2 = c(4,5), a3 = c(-1, -0.5)), k = 20 )

genInit <- function(bounds = list(a1 = c(-3, 3),
                        a2 = c(-3, 3),
                        a3 = c(-3, 3)),
                    k = 50)
{
    ans <- sapply(bounds, FUN = function(x){
        runif(k, x[1], x[2])
    })
    return(as.data.frame(ans))
}
