## ----echo=FALSE----------------------------------------------------------
require( gRbase )
prettyVersion <- packageDescription("gRbase")$Version
prettyDate <- format(Sys.Date())

## ----include=FALSE-------------------------------------------------------
library(knitr)
opts_chunk$set(
               fig.path='fig/graph',tidy=FALSE, 
               fig.height=2
)

## ----echo=FALSE, warning=FALSE------------------------------------------------
dir.create("fig")
oopt <- options()
options("digits"=4, "width"=80, "prompt"="R> ", "continue"="  ")
options(useFancyQuotes="UTF-8")

## ----echo=F-------------------------------------------------------------------
library(gRbase)
library(graph)

## -----------------------------------------------------------------------------
uG11 <- ug( ~a:b + b:c:d)
uG12 <- ug( c("a", "b"), c("b", "c", "d") )
uG13 <- ug( list( c("a", "b"), c("b", "c", "d") ) )

## -----------------------------------------------------------------------------
uG11
nodes(uG11)
str( edges(uG11) )
plot( uG11 )

## -----------------------------------------------------------------------------
uG11m <- ug( ~a:b + b:c:d, result="matrix")
uG11M <- ug( ~a:b + b:c:d, result="dgCMatrix")

## -----------------------------------------------------------------------------
daG11 <- dag( ~a:b + b:c:d)
daG12 <- dag( c("a", "b"), c("b", "c", "d") )
daG13 <- dag( list( c("a", "b"), c("b", "c", "d") ) )

## -----------------------------------------------------------------------------
daG11
nodes( daG11 )
str( edges( daG11 ) )
plot( daG11 )

## -----------------------------------------------------------------------------
daG11m <- dag( ~a:b + b:c:d, result="matrix")
daG11M <- dag( ~a:b + b:c:d, result="dgCMatrix")

## -----------------------------------------------------------------------------
d1.bi <- dag(~a:b + b:a)
edgemode( d1.bi )
str( edges(d1.bi) )

## -----------------------------------------------------------------------------
d2.cyc <- dag(~a:b + b:c + c:a)

## -----------------------------------------------------------------------------
par(mfrow=c(1,2)); plot(d1.bi); plot(d2.cyc)

## ----results='markup', eval=F-------------------------------------------------
#  dag(~a:b + b:c + c:a, forceCheck=TRUE)

## -----------------------------------------------------------------------------
mat <- as(uG11, "matrix")
Mat <- as(mat, "dgCMatrix")
NEL <- as(Mat, "graphNEL")

## -----------------------------------------------------------------------------
mat <- coerceGraph(uG11, "matrix")
Mat <- coerceGraph(uG11, "dgCMatrix")
NEL <- coerceGraph(mat, "graphNEL")

## -----------------------------------------------------------------------------
mat <- graphNEL2M(uG11, result="matrix")
Mat <- graphNEL2M(uG11, result="dgCMatrix")
NEL <- M2graphNEL(mat)

## -----------------------------------------------------------------------------
str( M2adjList(mat) )

## -----------------------------------------------------------------------------
daG11.mor <- moralize(daG11)

## -----------------------------------------------------------------------------
par(mfrow=c(1,2)); plot(daG11); plot(daG11.mor)

## -----------------------------------------------------------------------------
moralize( daG11m, result="dgCMatrix" )

## -----------------------------------------------------------------------------
topoSort(daG11)
topoSort(daG11m)
topoSort(daG11M)

## -----------------------------------------------------------------------------
topoSort(dag(~a:b + b:c + c:a))

## -----------------------------------------------------------------------------
topoSort( ug( ~a:b ) )

## -----------------------------------------------------------------------------
str( getCliques(uG11) )
str( getCliques(uG11m) )
str( getCliques(uG11M) )

## -----------------------------------------------------------------------------
mcs(uG11)
mcs(uG11m)
mcs(uG11M)

## -----------------------------------------------------------------------------
mcs(uG11, root=c("a","c"))

## -----------------------------------------------------------------------------
mcs( daG11 )
mcs( as(daG11, "matrix") )

## -----------------------------------------------------------------------------
uG <- ug( ~a:b:c + c:d + d:e + a:e + f:g )
mcs(uG)
(tuG  <- triangulate(uG))
mcs(tuG)

## -----------------------------------------------------------------------------
(tuG  <- triangulate(uG))

## -----------------------------------------------------------------------------
par(mfrow=c(1,2)); plot(uG); plot(tuG)

## -----------------------------------------------------------------------------
rp <- rip(tuG); rp

## -----------------------------------------------------------------------------
plot( rp )

## -----------------------------------------------------------------------------
names(rp)
rp$nodes
rp$host
rp$children
str(rp$separators)

## -----------------------------------------------------------------------------
g1 <- ug(~a:b + b:c + c:d + d:e + e:f + a:f + b:e)
g1mt <- minimalTriang(g1) # A minimal triangulation

## -----------------------------------------------------------------------------
par(mfrow = c(1,2)); plot(g1); plot(g1mt)

## -----------------------------------------------------------------------------
g2 <- ug(~a:b:e:f + b:c:d:e)
g1mt2 <- minimalTriang(g1, tobject=g2)

## -----------------------------------------------------------------------------
par(mfrow = c(1,2)); plot(g2); plot(g1mt2)

## -----------------------------------------------------------------------------
mm <- mpd( g1 ); mm

## -----------------------------------------------------------------------------
par(mfrow = c(1,2))
plot(subGraph(mm$cliques[[1]], g1))
plot(subGraph(mm$cliques[[2]], g1))

## -----------------------------------------------------------------------------
if(require(microbenchmark)){
    microbenchmark(
        RBGL::maxClique(uG11),
        getCliques(uG11),
        getCliques(uG11m),
        getCliques(uG11M),
        times=10) }

## -----------------------------------------------------------------------------
V <- 1:300
M <- 1:10
## Sparse graph
##
g1 <- randomGraph(V, M, 0.05)
length(edgeList(g1))
s <- c(NEL=object.size(g1), 
       dense=object.size(as(g1, "matrix")),
       sparse=object.size(as(g1, "dgCMatrix")))
s / max(s)
## More dense graph
##
g1 <- randomGraph(V, M, 0.5)
length(edgeList(g1))
s <- c(NEL=object.size(g1), 
       dense=object.size(as(g1, "matrix")),
       sparse=object.size(as(g1, "dgCMatrix")))
s / max(s)

## -----------------------------------------------------------------------------
args(querygraph)

## ----echo=FALSE--------------------------------------------------------------------
#rm(print.list)
options("width"=85)

