% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array-slice.R
\name{array-slice}
\alias{array-slice}
\alias{arslice}
\alias{arslice_entries}
\alias{arslice_mult}
\alias{arslice_prim}
\title{Array slices}
\usage{
arslice(tab, slice = NULL, margin = names(slice), drop = TRUE,
  as.array = FALSE)

arslice_prim(tab, slice, drop = TRUE)

arslice_mult(tab, slice, val = 1, comp = 0)

arslice_entries(tab, slice, complement = FALSE)
}
\arguments{
\item{tab}{An array with named dimnames.}

\item{slice}{A list defining the slice.}

\item{margin}{Names of variables in slice.}

\item{drop}{If TRUE then dimensions with only one level will be dropped
from the output.}

\item{as.array}{If the resulting array is one-dimensional the
result will by default be a vector with no dim attribute unless
as.array is TRUE.}

\item{val}{The values that entries in the slice will be multiplied
with.}

\item{comp}{The values that entries NOT in the slice will be
multiplied with.}

\item{complement}{If TRUE the complement of the entries are returned.}
}
\description{
Functions for extracting slices of arrays
}
\examples{

x = HairEyeColor
s = list(Hair=c("Black","Brown"), Eye=c("Brown", "Blue"))

## arslice
s1 = arslice(x, slice=s)
s1

## arslice_entries
arslice_entries(x, slice=s)
arslice_entries(x, slice=s, complement=TRUE)

## arslice_mult
s2 = arslice_mult(x, slice=s)
s2

## arslice_prim does the same as arslice - faster, but the function is less
# flexible
sp = list(c(1,2), c(1,2), TRUE)
arslice_prim(x, slice=sp)
arslice(x, slice=s)
if ( require(microbenchmark) ){
  microbenchmark(arslice_prim(x, slice=sp), arslice(x, slice=s))
}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\seealso{
\code{\link{arperm}}, \code{\link{armarg}}, \code{\link{armult}},
\code{\link{ardiv}}, \code{\link{aradd}}, \code{\link{arsubt}}, \code{\link{arsum}},
\code{\link{arprod}}
}

