% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grain-compile.R
\name{grain_compile}
\alias{grain_compile}
\alias{compile.grain}
\alias{compile.cpt_grain}
\alias{compile.pot_grain}
\title{Compile a graphical independence network (a Bayesian network)}
\usage{
\method{compile}{grain}(
  object,
  propagate = FALSE,
  root = NULL,
  control = object$control,
  details = 0,
  ...
)
}
\arguments{
\item{object}{A grain object.}

\item{propagate}{If TRUE the network is also propagated meaning
that the cliques of the junction tree are calibrated to each
other.}

\item{root}{A set of variables which must be in the root of the
junction tree}

\item{control}{Controlling the compilation process.}

\item{details}{For debugging info. Do not use.}

\item{\dots}{Currently not used.}
}
\value{
A compiled Bayesian network; an object of class
\code{grain}.
}
\description{
Compiles a Bayesian network. This means creating a
junction tree and establishing clique potentials; ; refer to
the reference below for details.
}
\references{
Søren Højsgaard (2012). Graphical Independence
Networks with the gRain Package for R. Journal of Statistical
Software, 46(10), 1-26.
\url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{grain}}, \code{\link[gRbase]{propagate}},
\code{\link{propagate.grain}},
\code{\link[gRbase]{triangulate}}, \code{\link[gRbase]{rip}},
\code{\link[gRbase]{junctionTree}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
