% Generated by roxygen2 (4.0.1): do not edit by hand
\name{replaceVariables}
\alias{replaceVariables}
\title{Replaces variables in a general graph with specified numeric values}
\usage{
replaceVariables(graph, variables = list(), ask = TRUE, partial = FALSE)
}
\arguments{
\item{graph}{A graph of class \code{\link{graphMCP}} or class
\code{\link{entangledMCP}}.}

\item{variables}{A named list with the specified real values, for example
\code{list(a=0.5, b=0.8, "tau"=0.5)}.  If \code{ask=TRUE} and this list is
missing at all or single variables are missing from the list, the user is
asked for the values (if the session is not interactive an error is thrown).}

\item{ask}{If \code{FALSE} all variables that are not specified are not
replaced.}

\item{partial}{IF \code{TRUE} only specified variables are replaced and
parameter \code{ask} is ignored.}
}
\value{
A graph or a matrix with variables replaced by the specified numeric
values.
}
\description{
Given a list of variables and real values a general graph is processed and
each variable replaced with the specified numeric value.
}
\examples{
graph <- HungEtWang2010()
\dontrun{
replaceVariables(graph)
}
replaceVariables(graph, list("tau"=0.5,"omega"=0.5, "nu"=0.5))
}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\seealso{
\code{\link{graphMCP}}, \code{\link{entangledMCP}}
}
\keyword{graphs}
\keyword{print}

