/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.util.Vector;
import org.af.jhlir.call.RList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.RControl;
import org.mutoss.gui.graph.Edge;
import org.mutoss.gui.graph.NetList;
import org.mutoss.gui.graph.Node;
import org.mutoss.gui.graph.VS;

public class GraphMCP {
    private static final Log logger = LogFactory.getLog(GraphMCP.class);
    String name;
    public Vector<Edge> edges = new Vector();
    public Vector<Node> knoten = new Vector();
    NetList nl;
    VS vs;

    public GraphMCP(String name, VS vs) {
        this.name = name;
        this.vs = vs;
        this.loadGraph(name);
        this.nl.revalidate();
        this.nl.repaint();
    }

    public void loadGraph(String name) {
        if (RControl.getR().eval("exists(\"" + name + "\")").asRLogical().getData()[0]) {
            String[] nodes = RControl.getR().eval("nodes(" + name + ")").asRChar().getData();
            double[] alpha = RControl.getR().eval("getWeights(" + name + ")").asRNumeric().getData();
            double[] x = RControl.getR().eval("getXCoordinates(" + name + ")").asRNumeric().getData();
            double[] y = RControl.getR().eval("getYCoordinates(" + name + ")").asRNumeric().getData();
            boolean[] rejected = RControl.getR().eval("getRejected(" + name + ")").asRLogical().getData();
            for (int i = 0; i < nodes.length; ++i) {
                logger.debug((Object)("Adding node " + nodes[i] + " at (" + x[i] + "," + y[i] + ")."));
                this.knoten.add(new Node(nodes[i], (int)x[i], (int)y[i], alpha[i], this.vs));
                if (!rejected[i]) continue;
                this.knoten.lastElement().reject();
            }
            RList edgeL = RControl.getR().eval("gMCP:::getEdges(" + name + ")").asRList();
            if (edgeL.get(0) != null) {
                String[] from = edgeL.get(0).asRChar().getData();
                String[] to = edgeL.get(1).asRChar().getData();
                double[] weight = edgeL.get(2).asRNumeric().getData();
                double[] labelX = edgeL.get(3).asRNumeric().getData();
                double[] labelY = edgeL.get(4).asRNumeric().getData();
                boolean[] curved = edgeL.get(5).asRLogical().getData();
                String[] weightStr = edgeL.get(6).asRChar().getData();
                for (int i = 0; i < from.length; ++i) {
                    Node fromNode = this.getNode(from[i]);
                    Node toNode = this.getNode(to[i]);
                    int xl = (int)labelX[i];
                    int yl = (int)labelY[i];
                    boolean curve = curved[i];
                    if (xl < -50 || yl < -50) {
                        this.edges.add(new Edge(fromNode, toNode, weightStr[i], this.vs, curve));
                        continue;
                    }
                    this.edges.add(new Edge(fromNode, toNode, weightStr[i], this.vs, xl + Node.getRadius(), yl + Node.getRadius()));
                }
            }
        }
        this.nl = this.vs.nl;
        for (Node k : this.knoten) {
            this.nl.addNode(k);
        }
        for (Edge e : this.edges) {
            this.nl.addEdge(e);
        }
    }

    private Node getNode(String name) {
        for (Node node : this.knoten) {
            if (!node.name.equals(name)) continue;
            return node;
        }
        return null;
    }
}

