% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_hide_elements}
\alias{g6_hide_elements}
\alias{g6_show_elements}
\title{Hide/show elements in a g6 graph}
\usage{
g6_hide_elements(graph, ids, animation = NULL)

g6_show_elements(graph, ids, animation = NULL)
}
\arguments{
\item{graph}{A g6 graph object or a g6_proxy object for Shiny applications.}

\item{ids}{Character vector specifying the IDs of elements to hide/show.
Can include node IDs, edge IDs, or combo IDs.}

\item{animation}{Boolean to toggle animation.}
}
\value{
The modified g6 graph or g6_proxy object, allowing for method chaining.
}
\description{
This function hides/shows specified elements (nodes, edges, or combos) in a g6 graph.
Hidden elements are removed from view but remain in the graph data structure.
}
\details{
When elements are hidden, they are removed from the visual display but still exist
in the underlying data structure. This means they can be shown again later using
\code{\link{g6_show_elements}} without having to recreate them.

Hidden elements will not participate in layout calculations, which may cause other
elements to reposition. When elements are shown again, the graph
may recalculate layout positions, which can cause other elements to reposition.
}
\seealso{
\code{\link{g6_show_elements}}
}
