% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockedReactions.R
\name{blockedReactions}
\alias{blockedReactions}
\title{Identify blocked reactions in a metabolic network}
\usage{
blockedReactions(model)
}
\arguments{
\item{model}{A valid model for the \code{'sybil'} package. An object of class modelorg.}
}
\value{
A vector with the reaction ids of the blocked reactions
}
\description{
A blocked reaction in a metabolic network is a reaction that not participate in any optimization solution. This function set as objective function each one of the reactions (one by time) in the model, and identifies the reactions without flux under all scenarios.
}
\examples{
\dontrun{
# Loading a model for the 'sybil' package
data("Ec_core")

# Identifying blocked reactions
blockedReactions(Ec_core)}
}
\author{
Andres Pinzon-Velasco <ampinzonv@unal.edu.co> - Mantainer: Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
\keyword{Blocked}
\keyword{genome}
\keyword{metabolic}
\keyword{reactions}
\keyword{reconstruction}
\keyword{scale}

