% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{comb_pb}
\alias{comb_pb}
\title{Combine results with progress bar}
\usage{
comb_pb(iterator, FUN = rbind, ...)
}
\arguments{
\item{iterator}{number of iterations}

\item{FUN}{function to combine the results (default: \code{rbind})}

\item{...}{optional parameters}
}
\description{
Combine results with progress bar, to be used in combination with
\code{foreach::foreach}
}
\examples{
\donttest{
# Load binary operator for backend
`\%do\%` <- foreach::`\%do\%`
N <- 5
out <- foreach::foreach(i = 1:N, 
                        .combine = comb_pb(N)) \%do\% {
                        Sys.sleep(1)
                        i
                       }
}
}
