% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfrl.r
\name{bfrl}
\alias{bfrl}
\title{Fuzzy Linear Regression Using the Boskovitch Fuzzy Regression Line Method}
\usage{
bfrl(x, y)
}
\arguments{
\item{x}{matrix with two colums, representing one independent variable observations.
The first column is
related to the intercept, so it consists of ones. Missing values not allowed.}

\item{y}{three column matrix of dependent variable values and the respective spread.
Method assumes non-symmetric triangular fuzzy input. Missing values not allowed.}
}
\value{
Returns a \code{fuzzylm} object that includes the model coefficients, limits
for data predictions from the model and the input data.
}
\description{
The function calculates fuzzy regression coeficients using the Boskovitch fuzzy
regression line method (BFRL) developed by Tanaka et al. (1989). Specifically, the
\code{min} problem is implemented in this function.
}
\details{
The function input expects the response in form of a non-symmetric fuzzy
number and the predictors as crisp numbers. The prediction returns
non-symmetric triangular fuzzy numbers. The intercept is a non-symmetric triangular
fuzzy number and the slope is a crisp number that is returned as a triangular fuzzy
number with spreads equal to zero.
}
\note{
Preferred use is through the \code{\link{fuzzylm}} wrapper function with argument
\code{method = "bfrl"}.
}
\examples{
data(fuzzydat)
fuzzylm(y ~ x, fuzzydat$tan, "bfrl", , , "yl", "yr")
}
\references{
Skrabanek, P., Marek, J. and Pozdilkova, A. (2021) Boscovich Fuzzy Regression
Line. \emph{Mathematics} 9: 685.
}
\seealso{
\code{\link{fuzzylm}}
}
\keyword{fuzzy}
