% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signalConditions.R
\name{signalConditions}
\alias{signalConditions}
\title{Signals Captured Conditions}
\usage{
signalConditions(
  future,
  include = "condition",
  exclude = NULL,
  resignal = TRUE,
  ...
)
}
\arguments{
\item{future}{A resolved \link{Future}.}

\item{include}{A character string of \link[base:condition]{condition}
classes to signal.}

\item{exclude}{A character string of \link[base:condition]{condition}
classes \emph{not} to signal.}

\item{resignal}{If TRUE, then already signaled conditions are signaled
again, otherwise not.}

\item{\dots}{Not used.}
}
\value{
Returns the \link{Future} where conditioned that were signaled
have been flagged to have been signaled.
}
\description{
Captured conditions that meet the \code{include} and \code{exclude}
requirements are signaled \emph{in the order as they were captured}.
}
\seealso{
Conditions are signaled by
\code{\link[base:signalCondition]{signalCondition}()}.
}
