% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusionAxis.R
\name{fusionAxis}
\alias{fusionAxis}
\title{Adding FusionCharts axis}
\usage{
fusionAxis(
  fusionPlot,
  xAxisName = "Change X axis",
  yAxisName = "Change Y axis",
  AxisNameFont = "Arial",
  AxisNameFontSize = "12",
  AxisNameFontColor = "#999999",
  AxisNameFontBold = TRUE,
  AxisNameFontItalic = FALSE
)
}
\arguments{
\item{fusionPlot}{fusionPlot object got by \code{fusionPlot()}}

\item{xAxisName}{Specify the title of the X-axis of the chart}

\item{yAxisName}{Specify the title of the Y-axis of the chart}

\item{AxisNameFont}{Set the font family of axis}

\item{AxisNameFontSize}{Set the font size (between 0 and 72) of axis}

\item{AxisNameFontColor}{Set the font color of axis in hex code}

\item{AxisNameFontBold}{Set the font style to bold}

\item{AxisNameFontItalic}{Set the font style to italic}
}
\description{
\url{https://www.fusioncharts.com/dev/chart-guide/chart-configurations/axes}
}
\examples{
library(fusionchartsR)
df <- data.frame(label = c("Venezuela", "Saudi", "Canada", "Russia"), value = c(290, 260,180, 115))
df \%>\%
fusionPlot(x = "label", y = "value", type = "column3d") \%>\%
fusionAxis(xAxisName = "Countries", yAxisName = "Numbers", AxisNameFontSize = "20") \%>\%
fusionCustomAxis(xAxisPosition = "top", yAxisPosition = "right") \%>\%
fusionTheme(theme = "gammel")

}
