% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lrner.R
\name{Lrner}
\alias{Lrner}
\title{Lrner Class}
\description{
This class implements a learner. A \link{Lrner} object can only exist as a component of a
\link{TrainLayer} or a \link{TrainMetaLayer} object.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Lrner-new}{\code{Lrner$new()}}
\item \href{#method-Lrner-print}{\code{Lrner$print()}}
\item \href{#method-Lrner-summary}{\code{Lrner$summary()}}
\item \href{#method-Lrner-interface}{\code{Lrner$interface()}}
\item \href{#method-Lrner-train}{\code{Lrner$train()}}
\item \href{#method-Lrner-getTrainLayer}{\code{Lrner$getTrainLayer()}}
\item \href{#method-Lrner-getNaRm}{\code{Lrner$getNaRm()}}
\item \href{#method-Lrner-getNaAction}{\code{Lrner$getNaAction()}}
\item \href{#method-Lrner-getId}{\code{Lrner$getId()}}
\item \href{#method-Lrner-getPackage}{\code{Lrner$getPackage()}}
\item \href{#method-Lrner-getIndSubset}{\code{Lrner$getIndSubset()}}
\item \href{#method-Lrner-getVarSubset}{\code{Lrner$getVarSubset()}}
\item \href{#method-Lrner-getParamPred}{\code{Lrner$getParamPred()}}
\item \href{#method-Lrner-getParamInterface}{\code{Lrner$getParamInterface()}}
\item \href{#method-Lrner-getExtractPred}{\code{Lrner$getExtractPred()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-new"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-new}{}}}
\subsection{Method \code{new()}}{
Initialize a default parameters list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$new(
  id,
  package = NULL,
  lrn_fct,
  param_train_list,
  param_pred_list = list(),
  train_layer,
  na_action = "na.rm"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character} \cr
Learner ID.}

\item{\code{package}}{\code{character} \cr
Package that implements the learn function. If NULL, the}

\item{\code{lrn_fct}}{\code{character} \cr
learn function is called from the current environment.}

\item{\code{param_train_list}}{\code{list} \cr
List of parameter for training.}

\item{\code{param_pred_list}}{\code{list} \cr
List of parameter for testing.
Learn parameters.}

\item{\code{train_layer}}{\code{TrainLayer} \cr
Layer on which the learner is stored.}

\item{\code{na_action}}{\code{character} \cr
Handling of missing values. Set to "na.keep" to keep missing values, "na.rm" to remove individuals with missing values or "na.impute" (only applicable on meta-data) to impute missing values in meta-data. Only median and mode based imputations are actually handled. With the "na.keep" option, ensure that the provided learner can handle missing values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-print"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-summary"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-summary}{}}}
\subsection{Method \code{summary()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$summary(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-interface"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-interface}{}}}
\subsection{Method \code{interface()}}{
Learner and prediction parameter interface. Use this function
to provide how the following parameters are named in the learning
function (\code{lrn_fct}) you provided when creating the learner, or in the predicting function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$interface(
  x = "x",
  y = "y",
  object = "object",
  data = "data",
  extract_pred_fct = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{character} \cr
Name of the argument to pass the matrix of independent variables in the original learning function.}

\item{\code{y}}{\code{character} \cr
Name of the argument to pass the response variable in the original learning function.}

\item{\code{object}}{\code{character} \cr
Name of the argument to pass the model in the original predicting function.}

\item{\code{data}}{\code{character} \cr
Name of the argument to pass new data in the original predicting function.}

\item{\code{extract_pred_fct}}{\code{character} or \code{function} \cr
If the predict function that is called for the model does not return a vector, then
use this argument to specify a (or a name of a) function that can be used to extract vector of predictions.
Default value is NULL, if predictions are in a vector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-train"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-train}{}}}
\subsection{Method \code{train()}}{
Tains the current learner (from class \link{Lrner}) on the current training data (from class \link{TrainData}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$train(ind_subset = NULL, use_var_sel = FALSE, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ind_subset}}{\code{vector} \cr
Individual ID subset on which the training will be performed.}

\item{\code{use_var_sel}}{\code{boolean} \cr
If TRUE, variable selection is performed before training.}

\item{\code{verbose}}{\code{boolean} \cr
Warning messages will be displayed if set to TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The resulting model, from class \link{Model}, is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getTrainLayer"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getTrainLayer}{}}}
\subsection{Method \code{getTrainLayer()}}{
The current layer is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getTrainLayer()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\link{TrainLayer} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getNaRm"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getNaRm}{}}}
\subsection{Method \code{getNaRm()}}{
The current layer is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getNaRm()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getNaAction"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getNaAction}{}}}
\subsection{Method \code{getNaAction()}}{
The current layer is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getNaAction()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getId"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getId}{}}}
\subsection{Method \code{getId()}}{
Getter of the current learner ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current learner ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getPackage"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getPackage}{}}}
\subsection{Method \code{getPackage()}}{
Getter of the learner package implementing the learn function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getPackage()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of the package implementing the learn function.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getIndSubset"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getIndSubset}{}}}
\subsection{Method \code{getIndSubset()}}{
Getter of the learner package implementing the learn function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getIndSubset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The name of the package implementing the learn function.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getVarSubset"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getVarSubset}{}}}
\subsection{Method \code{getVarSubset()}}{
Getter of the variable subset used for training.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getVarSubset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list of variables used for training is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getParamPred"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getParamPred}{}}}
\subsection{Method \code{getParamPred()}}{
Getter predicting parameter list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getParamPred()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list of predicting parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getParamInterface"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getParamInterface}{}}}
\subsection{Method \code{getParamInterface()}}{
The current parameter interface is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getParamInterface()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data.frame of interface.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Lrner-getExtractPred"></a>}}
\if{latex}{\out{\hypertarget{method-Lrner-getExtractPred}{}}}
\subsection{Method \code{getExtractPred()}}{
The function to extract predicted values is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Lrner$getExtractPred()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data.frame of interface.
}
}
}
