% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot-files.R
\name{spot_funs_files}
\alias{spot_funs_files}
\alias{spot_pkgs_files}
\alias{spot_things_files}
\title{Spot Packages or Functions in dataframe of Paths}
\usage{
spot_funs_files(df, ..., .progress = TRUE)

spot_pkgs_files(df, ..., .progress = TRUE)
}
\arguments{
\item{df}{Dataframe containing a column of \code{absolute_paths}.}

\item{...}{Arguments passed onto \verb{spot_\{pkgs|funs\}()}.}

\item{.progress}{Whether to show a progress bar. Use \code{TRUE} to a turn on
a basic progress bar, use a string to give it a name, or see
\link[purrr]{progress_bars} for more details.}
}
\value{
Dataframe with \code{relative_paths} and \code{absolute_paths} of file paths
along with a list-column \code{spotted} containing \code{purrr::safely()} named list
of "result" and "error" for each file parsed. Use \code{unnest_results()} to
unnest only the "result" values.
}
\description{
\code{spot_pkgs_files()} : Spot all packages that show-up in R or Rmarkdown or
quarto documents in a dataframe of filepaths.

\code{spot_funs_files()} : Spot all functions and their corresponding packages
that show-up in R or Rmarkdown or quarto documents in a dataframe of
filepaths.
}
\details{
A \code{purrr::safely()} wrapper for mapping \code{spot_pkgs()} or \code{spot_funs()} across
multiple filepaths. I.e. even if some files fail to parse the function will
continue on.

Default settings are meant for files where package libraries are referenced
\emph{within} the files themselves. See README for more details.
}
\examples{
\donttest{
library(funspotr)
library(dplyr)

list_files_github_repo("brshallo/feat-eng-lags-presentation", branch = "main") \%>\%
  spot_funs_files()
}
}
\seealso{
\code{\link[=spot_pkgs]{spot_pkgs()}}, \code{\link[=spot_funs]{spot_funs()}}, \code{\link[=unnest_results]{unnest_results()}}
}
