% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mfd.R
\name{plot_bifd}
\alias{plot_bifd}
\title{Plot a Bivariate Functional Data Object.}
\usage{
plot_bifd(bifd_obj, type_plot = "raster", phi = 40, theta = 40)
}
\arguments{
\item{bifd_obj}{A bivariate functional data object of class bifd,
containing one single replication.}

\item{type_plot}{a character value
If "raster", it plots the bivariate functional data object
as a raster image.
If "contour", it produces a contour plot.
If "perspective", it produces a perspective plot.
Default value is "raster".}

\item{phi}{If \code{type_plot=="perspective"}, it is the \code{phi} argument
of the function \code{plot3D::persp3D}.}

\item{theta}{If \code{type_plot=="perspective"}, it is the \code{theta} argument
of the function \code{plot3D::persp3D}.}
}
\value{
A ggplot with a geom_tile layer providing a plot of the
bivariate functional data object as a heat map.
}
\description{
Plot an object of class \code{bifd} using
\code{ggplot2} and \code{geom_tile}.
The object must contain only one single functional replication.
}
\examples{
library(funcharts)
mfdobj <- data_sim_mfd(nobs = 1)
tp <- tensor_product_mfd(mfdobj)
plot_bifd(tp)

}
