% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cross_plot.R
\name{massive_cross_plot}
\alias{massive_cross_plot}
\title{Generate several cross_plot at the same time.}
\usage{
massive_cross_plot(data, str_target, str_vars, path_out, auto_binning)
}
\arguments{
\item{data}{data frame source}

\item{str_target}{string of the variable to predict}

\item{str_vars}{vector of strings containing the variables names to be used as input in each cross_plot.}

\item{path_out}{path directory, if it has a value the plot is saved in 'path_out'}

\item{auto_binning}{indicates the automatic binning of str_input variable based on equal frequency (function 'equal_freq'), default value=TRUE}
}
\description{
It creates as many cross_plots as variable names are present in 'str_vars'. Additionally, they can be saved as jpeg in a folder (setting 'path_out' parameter).
}
\examples{
## Example 1
massive_cross_plot(data=heart_disease,
str_target="has_heart_disease",
str_vars=c("age", "oldpeak", "max_heart_rate"))

## Example 2: Save all the plots to a new folder "plots_example" inside the working directory.
massive_cross_plot(data=heart_disease, str_target="has_heart_disease",
str_vars=c("age", "oldpeak", "max_heart_rate"),
path_out="plots_example")
}

