% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_minidend.R
\name{get_minidend}
\alias{get_minidend}
\title{Generate Minimum Dendrogram from Hierarchical Clustering}
\usage{
get_minidend(adj_fMSR)
}
\arguments{
\item{adj_fMSR}{A numeric matrix or a distance object representing the dissimilarity matrix 
computed from functional data. This matrix is used to perform hierarchical clustering.}
}
\value{
A dendrogram object representing the clustered data. The dendrogram is cut at the identified height,
        resulting in a tree structure that can be used for further analysis or visualization.
}
\description{
This function generates a minimum dendrogram by performing hierarchical clustering on an input distance matrix. 
The function identifies an optimal height cut based on the largest gap in cluster heights and returns the resulting 
dendrogram, allowing for further analysis of clustering structures.
}
\details{
The function performs the following steps:
1. Uses `fastcluster::hclust` to perform hierarchical clustering on the provided dissimilarity matrix using 
   the "complete" method.
2. Extracts the heights of the clusters and identifies the largest gap in heights to determine the optimal 
   cut position for the dendrogram.
3. Cuts the dendrogram at the identified height and returns the lower part of the cut.
}
