% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_occurrences.R
\name{.find_occurrences}
\alias{.find_occurrences}
\title{Find Occurrences of a Motif}
\usage{
.find_occurrences(v, Y, R, alpha, w, c_k, use0, use1, transformed = FALSE)
}
\arguments{
\item{v}{A list containing two matrices:
- \code{v0}: The first set of motif values.
- \code{v1}: The second set of motif values.
Each matrix should have \( d \) columns corresponding to the dimensions.}

\item{Y}{A list of \( N \) lists, each containing two matrices:
- \code{Y0}: The first set of curve values.
- \code{Y1}: The second set of curve values.
Each matrix should have \( d \) columns corresponding to the dimensions.}

\item{R}{A numeric value representing the maximum allowed dissimilarity.}

\item{alpha}{A numeric value that serves as a weight coefficient between the L2 norms 
of the two sets of motifs when using the dissimilarity function \code{diss_d0_d1_L2}.}

\item{w}{A numeric vector of weights for the dissimilarity index across different dimensions.
All weights must be positive (\( w > 0 \)).}

\item{c_k}{An integer specifying the minimum length of the intersection of the supports 
of the shifted motif and the curves.}

\item{use0}{A logical value indicating whether to use the first component of the curves (i.e., \( Y0 \) and \( v0 \)).}

\item{use1}{A logical value indicating whether to use the second component of the curves (i.e., \( Y1 \) and \( v1 \)).}

\item{transformed}{A logical value indicating whether to normalize the curve segments to the interval [0,1] before applying the dissimilarity measure. Setting `transformed = TRUE` scales each curve segment between 0 and 1, which allows for the identification of motifs with consistent shapes but different amplitudes. This normalization is useful for cases where motif occurrences may vary in amplitude but have similar shapes, enabling better pattern recognition across diverse data scales.}
}
\value{
A matrix with three columns:
        - \code{curve}: The ID of the curve where the motif was found.
        - \code{shift}: The optimal shift at which the motif occurs.
        - \code{diss}: The dissimilarity value associated with the match.
        If no occurrences are found, an empty matrix is returned.
}
\description{
Finds occurrences of a specified motif in a set of curves, where the dissimilarity is lower than a specified threshold \( R \). 
The function compares the motif against curves represented in multiple dimensions and returns the details of matching occurrences.
}
\details{
The function systematically checks each curve in the provided list against the specified motif 
to identify positions where the dissimilarity does not exceed the defined threshold \( R \). 
It handles multidimensional curves and can selectively consider different components of the motifs and curves.
}
\author{
Marzia Angela Cremona & Francesca Chiaromonte
}
