% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\docType{methods}
\name{plot.multiFunData}
\alias{plot.multiFunData}
\alias{plot,multiFunData,missing-method}
\title{Plotting multivariate functional data}
\usage{
plot.multiFunData(x, y, obs = seq_len(nObs(x)), dim = seq_len(length(x)),
  par.plot = NULL, main = names(x), xlab = "argvals", ylab = "",
  log = "", ylim = NULL, ...)

\S4method{plot}{multiFunData,missing}(x, y, ...)
}
\arguments{
\item{x}{An object of class \code{multiFunData}.}

\item{y}{Missing.}

\item{obs}{A vector of numerics giving the observations to plot. Defaults to 
all observations in \code{x}. For two-dimensional functions (images) 
\code{obs} must have length 1.}

\item{dim}{The dimensions to plot. Defaults to \code{length(x)}, i.e. all 
functions in \code{x} are plotted.}

\item{par.plot}{Graphic parameters to be passed to the plotting regions. The 
option \code{mfrow} is ignored. Defaults to \code{NULL}. See 
\code{\link[graphics]{par}} for details.}

\item{main}{A string vector, giving the title of the plot. Can have the same 
length as \code{dim} (different titles for each dimension) or length 
\code{1} (one title for all dimensions). Defaults to \code{names(x)}.}

\item{xlab, ylab}{The titles for x- and y-axis. Defaults to \code{"argvals"} 
for the x-axis and no title for the y-axis for all elements. Can be 
supplied as a vector of the same length as \code{dim} (one x-/y-lab for each 
element) or a single string that is applied for all elements. See 
\code{\link[graphics]{plot}} for details.}

\item{log}{A character string, specifying the axis that is to be logarithmic.
Can be \code{""} (non-logarithmic axis), \code{"x", "y", "xy"} or 
\code{"yx"}. Defaults to \code{""} for all plots. Can be supplied as a 
vector of the same length as \code{dim} (one log-specification for each 
element) or a single string that is applied for all elements. See 
\code{\link[graphics]{plot.default}} for details.}

\item{ylim}{Specifies the limits of the y-Axis. Can be either \code{NULL} 
(the default, limits are chosen automatically), a vector of length 2 
(giving the minimum and maximum range for all elements at the same time) or
a list of the same length as \code{dim} (specifying the limits for each
element separately).}

\item{...}{Additional arguments to \code{plot}.}
}
\description{
This function plots observations of multivariate functional data on their domain. The graphic
device is split in a number of subplots (specified by \code{dim}) via \code{mfrow}
(\code{\link[graphics]{par}}) and the univariate elements are plotted using \code{plot}.
}
\section{Warning}{
 The function is currently implemented only for functional data with one- and
  two-dimensional domains.
}

\examples{
oldpar <- par(no.readonly = TRUE)
argvals <- seq(0, 2*pi, 0.1)

# One-dimensional elements
f1 <- funData(argvals, outer(seq(0.75, 1.25, length.out = 11), sin(argvals)))
f2 <- funData(argvals, outer(seq(0.75, 1.25, length.out = 11), cos(argvals)))

m1 <- multiFunData(f1, f2)
plot(m1, main = c("1st element", "2nd element")) # different titles
plot(m1, main = "Multivariate Functional Data") # one title for all

# Mixed-dimensional elements
X <- array(0, dim = c(11, length(argvals), length(argvals)))
X[1,,] <- outer(argvals, argvals, function(x,y){sin((x-pi)^2 + (y-pi)^2)})
g <- funData(list(argvals, argvals), X)

m2 <- multiFunData(f1, g)
# different titles and labels
plot(m2, main = c("1st element", "2nd element"), obs = 1,
     xlab = c("xlab1", "xlab2"), 
     ylab = "one ylab for all")
# one title for all
plot(m2, main = "Multivariate Functional Data", obs = 1) 

\dontrun{plot(m2, main = c("1st element", "2nd element")) # must specify obs!}

par(oldpar)
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{multiFunData}}, 
  \code{\link{plot.funData}}
}
