% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/functional-spectral-density.R
\name{Spec_compare_localize_freq_curvelength}
\alias{Spec_compare_localize_freq_curvelength}
\title{Compare the spectral density operator of two Functional Time Series and localize frequencies at which they differ, and (spatial) regions where they differ}
\usage{
Spec_compare_localize_freq_curvelength(X, Y, B.T = (dim(X)[1])^(-1/5), W,
  alpha = 0.05, accept = 0, reject = 1, verbose = 0, demean = FALSE)
}
\arguments{
\item{X}{The \eqn{T \times nbasis} matrices of containing the coordinates, expressed in some functional basis,  of the two FTS that to be compared.
expressed in a basis.}

\item{Y}{The \eqn{T \times nbasis} matrices of containing the coordinates, expressed in some functional basis,  of the two FTS that to be compared.
expressed in a basis.}

\item{B.T}{The bandwidth of frequencies over which the periodogram operator
is smoothed. If \code{B.T=0},  the periodogram operator is returned.}

\item{W}{The weight function used to smooth the periodogram operator. Set by
default to be the Epanechnikov kernel}

\item{alpha}{level for the test}

\item{accept,reject}{values for accepted, rejected regions}

\item{verbose}{A  variable to show the progress of the computations. By
default, \code{verbose=0}.}

\item{demean}{A logical variable to choose if the FTS is centered before
computing its spectral density operator.}
}
\description{
Compare the spectral density operator of two Functional Time Series and localize frequencies at which they differ, and (spatial) regions where they differ
}
\examples{
ma.scale2=ma.scale1=c(-1.4,2.3,-2)
ma.scale2[3] = ma.scale1[3]+.4
a1=Generate_filterMA(10, 10, MA.len=3, ma.scale=ma.scale1)
a2=Generate_filterMA(10, 10, MA.len=3, ma.scale=ma.scale2)
X=Simulate_new_MA(a1, T.len=2^9, noise.type='wiener')
Y=Simulate_new_MA(a2, T.len=2^9, noise.type='wiener')
ans0=Spec_compare_localize_freq_curvelength(X, Y, W=Epanechnikov_kernel, alpha=.01, demean=TRUE)
print(ans0)
plot(ans0)
rm(ma.scale1, ma.scale2, a1, a2, X, Y, ans0)
}

