% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxORF.R
\name{maxORF}
\alias{maxORF}
\title{Maximum Open Reading Frame in DNA (maxORF)}
\usage{
maxORF(seqs, reverse = TRUE, label = c())
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{reverse}{It is a logical parameter which assumes the reverse complement of the sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
A vector containing a subsequence for each given sequences. The subsequence is the maximum ORF of the sequence.
}
\description{
This function gets a sequence as the input.
If reverse is true, the function extracts the max Open Reading Frame in the sequence and its reverse complement (hint: Six frames).
Otherwise, only the sequence is searched (hint: Three frames).
}
\note{
If a sequence does not contain ORF, the function deletes the sequence.
}
\examples{

fileLNC<-system.file("extdata/Athaliana_LNCRNA.fa",package="ftrCOOL")
ORF<-maxORF(seqs=fileLNC,reverse=FALSE)
}
