% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDE.R
\name{DDE}
\alias{DDE}
\title{Dipeptide Deviation from Expected Mean value}
\usage{
DDE(seqs, label = c())
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
A feature matrix with 20^2=400 number of columns. The number of rows is equal to the number of sequences.
}
\description{
This function computes the dipeptide deviation from the expected mean value.
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")
mat<-DDE(seqs=filePrs)

}
