% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spa_functions.R
\name{fsr_eval_modes}
\alias{fsr_eval_modes}
\alias{soft_eval}
\alias{strict_eval}
\alias{alpha_eval}
\alias{soft_alpha_eval}
\title{Evaluation modes}
\usage{
soft_eval(degree)

strict_eval(degree)

alpha_eval(degree, alpha)

soft_alpha_eval(degree, alpha)
}
\arguments{
\item{degree}{A numerical vector whose values are in [0, 1].}

\item{alpha}{A single numeric value in [0, 1].}
}
\value{
A Boolean vector.
}
\description{
This family of functions implements evaluation modes
that returns a Boolean value for a given degree in [0, 1] obtained from a membership function of a linguistic value.
}
\details{
These functions yield a Boolean value that express the meaning of a degree returning from an evaluation of a membership function.
That is, the parameter \code{degree} is a value in [0, 1] resulting from evaluation a value in a membership degree.
Then, an evaluation mode "translate" the meaning of this degree of truth as a Boolean value.

There some different ways to make this kind of translation:
\itemize{
\item \code{soft_eval}: It returns \code{TRUE} if \code{degree} is greater than 0.
\item \code{strict_eval}: It returns \code{TRUE} if \code{degree} is equal to 0.
\item \code{alpha_eval}: It returns \code{TRUE} if \code{degree} is greater than or equal to another value (named \code{alpha}).
\item \code{soft_alpha_eval}: It returns \code{TRUE} if \code{degree} is greater than another value (named \code{alpha}).
}

These operators are employed to process the evaluation modes of fuzzy topological relationships that are processed as Boolean predicates.
}
\examples{

x <- c(0.1, 0.3, 0.6, 0.8)

soft_eval(x)
strict_eval(x)
alpha_eval(x, 0.3)
soft_alpha_eval(x, 0.3)

}
