% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xfibres.R
\name{xfibres}
\alias{xfibres}
\alias{bedpostx}
\title{Bayesian Estimation of Diffusion Parameters 
Obtained using Sampling Techniques with Crossing Fibers}
\usage{
xfibres(
  infile,
  bvecs,
  bvals,
  mask = NULL,
  nfibres = 1,
  bet.opts = "",
  verbose = TRUE,
  njumps = NULL,
  burnin = NULL,
  burnin_noard = NULL,
  sampleevery = NULL,
  updateproposalevery = NULL,
  seed = NULL,
  noard = FALSE,
  allard = FALSE,
  nospat = FALSE,
  nonlinear = FALSE,
  cnonlinear = FALSE,
  rician = FALSE,
  f0 = FALSE,
  ardf0 = FALSE,
  opts = ""
)
}
\arguments{
\item{infile}{Input filename}

\item{bvecs}{b-vectors: matrix of 3 columns or 
filename of ASCII text file}

\item{bvals}{b-values: vector of same length as number of rows of 
b-vectors or filename of ASCII text file}

\item{mask}{Mask filename}

\item{nfibres}{Maximum number of fibres to fit in each voxel (default 1)}

\item{bet.opts}{Options for \code{\link{fslbet}} if mask is not supplied}

\item{verbose}{print diagnostic messages}

\item{njumps}{num of jumps to be made by MCMC (default is 5000)}

\item{burnin}{Total num of jumps at start of MCMC to be discarded (default is 0)}

\item{burnin_noard}{num of burnin jumps before the ard is imposed (default is 0)}

\item{sampleevery}{num of jumps for each sample (MCMC) (default is 1)}

\item{updateproposalevery}{num of jumps for each update to the proposal density std (MCMC) (default is 40)}

\item{seed}{for pseudo random number generator}

\item{noard}{Turn ARD off on all fibres}

\item{allard}{Turn ARD on on all fibres}

\item{nospat}{Initialise with tensor, not spatially}

\item{nonlinear}{Initialise with nonlinear fitting}

\item{cnonlinear}{Initialise with constrained nonlinear fitting}

\item{rician}{Use Rician noise modelling}

\item{f0}{Add to the model an unattenuated signal compartment}

\item{ardf0}{Use ard on f0}

\item{opts}{Additional options for \code{xfibres}.
There should not be any left out in the current arguments, but 
\code{opts} may be a way some prefer to input options.}
}
\value{
Output from \code{\link{system}}
}
\description{
Calls \code{xfibres} from FSL to fit, also known as
\code{bedpostx}
}
