% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic.R
\name{geodesic.ballstats}
\alias{geodesic.ballstats}
\title{Compute geodesic ball area and perimeter at location defined by geodists for all radii.}
\usage{
geodesic.ballstats(mesh, geodist, sample_at_radii)
}
\arguments{
\item{mesh}{tmesh3d instance}

\item{geodist}{vector of geodesic distance for current mesh vertex under consideration (no need for the index)}

\item{sample_at_radii}{double vector, the different ball radii for which to perform the computation}
}
\value{
named list with entries: 'ball_area': vector of double, ball area at each sample radius. 'ball_perimeter': vector of double, ball perimeter at each sample radius.
}
\description{
Compute geodesic ball area and perimeter at location defined by geodists for all radii.
}
\note{
This is called from \code{geodesic.circles}, there should be no need to call it directly.
}
\keyword{internal}
