% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloredmesh.R
\name{coloredmesh.from.morphdata}
\alias{coloredmesh.from.morphdata}
\title{Create a coloredmesh from arbitrary data.}
\usage{
coloredmesh.from.morphdata(
  subjects_dir,
  vis_subject_id,
  morph_data,
  hemi,
  surface = "white",
  makecmap_options = mkco.seq()
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{vis_subject_id}{string. The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{morph_data}{string. The morphometry data to use. E.g., 'area' or 'thickness.'}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface}{character string or `fs.surface` instance. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{makecmap_options}{named list of parameters to pass to \code{\link{makecmap}}. Must not include the unnamed first parameter, which is derived from 'measure'.}
}
\value{
coloredmesh. A named list with entries: "mesh" the \code{\link{tmesh3d}} mesh object. "col": the mesh colors. "render", logical, whether to render the mesh. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create a coloredmesh from arbitrary data.
}
\seealso{
Other coloredmesh functions: 
\code{\link{coloredmesh.from.annot}()},
\code{\link{coloredmesh.from.label}()},
\code{\link{coloredmesh.from.mask}()},
\code{\link{coloredmesh.from.morph.native}()},
\code{\link{coloredmesh.from.morph.standard}()},
\code{\link{coloredmeshes.from.color}()}
}
\concept{coloredmesh functions}
