% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloredmesh.R
\name{coloredmesh.from.label}
\alias{coloredmesh.from.label}
\title{Create a coloredmesh from a label.}
\usage{
coloredmesh.from.label(
  subjects_dir,
  subject_id,
  label,
  hemi,
  surface = "white",
  makecmap_options = list(colFn = squash::rainbow2),
  binary = TRUE
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{label}{string or vector of integers. If a string, the name of the label file, without the hemi part (if any), but including the '.label' suffix. E.g., 'cortex.label' for '?h.cortex.label'. Alternatively, the already loaded label data as a vector of integers.}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface}{character string or `fs.surface` instance. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{makecmap_options}{named list of parameters to pass to \code{\link{makecmap}}. Must not include the unnamed first parameter, which is derived from 'measure'.}

\item{binary}{logical, whether to treat the label as binary}
}
\value{
coloredmesh. A named list with entries: "mesh" the \code{\link{tmesh3d}} mesh object. "col": the mesh colors. "render", logical, whether to render the mesh. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create a coloredmesh from a label.
}
\seealso{
Other coloredmesh functions: 
\code{\link{coloredmesh.from.annot}()},
\code{\link{coloredmesh.from.mask}()},
\code{\link{coloredmesh.from.morph.native}()},
\code{\link{coloredmesh.from.morph.standard}()},
\code{\link{coloredmesh.from.morphdata}()},
\code{\link{coloredmeshes.from.color}()}
}
\concept{coloredmesh functions}
