% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.subject.annot}
\alias{vis.subject.annot}
\title{Visualize an annotation for a subject.}
\usage{
vis.subject.annot(
  subjects_dir,
  subject_id,
  atlas,
  hemi = "both",
  surface = "white",
  views = c("t4"),
  rgloptions = list(),
  rglactions = list(),
  outline = FALSE
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{atlas}{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{hemi}{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{views}{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to \code{\link[rgl]{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{outline}{logical, whether to draw an outline only instead of filling the regions. Defaults to FALSE.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Creates a surface mesh, loads the colors from the annotation, and renders the resulting colored mesh in an interactive window. If hemi is 'both', the data is rendered for the whole brain.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   vis.subject.annot(subjects_dir, 'subject1', 'aparc', 'both');
}

}
\seealso{
Other visualization functions: 
\code{\link{vis.color.on.subject}()},
\code{\link{vis.data.on.fsaverage}()},
\code{\link{vis.data.on.subject}()},
\code{\link{vis.labeldata.on.subject}()},
\code{\link{vis.mask.on.subject}()},
\code{\link{vis.region.values.on.subject}()},
\code{\link{vis.subject.label}()},
\code{\link{vis.subject.morph.native}()},
\code{\link{vis.subject.morph.standard}()},
\code{\link{vis.symmetric.data.on.subject}()},
\code{\link{vislayout.from.coloredmeshes}()}

Other region-based visualization functions: 
\code{\link{vis.region.values.on.subject}()}
}
\concept{region-based visualization functions}
\concept{visualization functions}
