% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloredmesh.R
\name{coloredmesh.from.mask}
\alias{coloredmesh.from.mask}
\title{Create a coloredmesh from a mask.}
\usage{
coloredmesh.from.mask(subjects_dir, subject_id, mask, hemi,
  surface = "white", colormap = squash::rainbow2,
  surface_data = NULL)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{mask}{logical vector, contains one logical value per vertex.}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap}{a colormap. See the squash package for some colormaps. Defaults to [squash::rainbow2].}

\item{surface_data}{optional surface object, as returned by [fsbrain::subject.surface]. If given, used instead of loading the surface data from disk (which users of this function may already have done). Defaults to NULL.}
}
\value{
coloredmesh. A named list with entries: "mesh" the [rgl::tmesh3d] mesh object. "col": the mesh colors. "morph_data_was_all_na", logical. Whether the mesh values were all NA, and thus replaced by the all_nan_backup_value. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create a coloredmesh from a mask.
}
\seealso{
Other mask functions: \code{\link{mask.from.labeldata.for.hemi}},
  \code{\link{vis.mask.on.subject}}
}
\concept{mask functions}
